/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterators;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongList;
import com.almworks.integers.wrappers.LongIntHppcOpenHashMap;
import java.util.Map;

public class LongListHashIndex {
    private final LongIntHppcOpenHashMap myMap;

    public LongListHashIndex(LongList list) {
        this.myMap = new LongIntHppcOpenHashMap(list.size());
        this.myMap.putAllKeys((LongIterable)list, (IntIterable)IntIterators.range((int)list.size()));
    }

    public LongListHashIndex(Map<Long, Integer> map) {
        this.myMap = new LongIntHppcOpenHashMap(map.size());
        for (Map.Entry<Long, Integer> e : map.entrySet()) {
            Long key = e.getKey();
            Integer value = e.getValue();
            if (key == null || value == null || value < 0) continue;
            this.myMap.put(key.longValue(), value.intValue());
        }
    }

    public int indexOf(long value) {
        if (this.myMap.containsKey(value)) {
            return this.myMap.lget();
        }
        return -1;
    }

    public int size() {
        return this.myMap.size();
    }
}

