/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.CoreItemTypes;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.row.StructureRows;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public final class ShallowRow
implements StructureRow {
    private final long myRowId;
    @NotNull
    private final ItemIdentity myItemId;
    private final long mySemantics;

    public ShallowRow(long rowId, @NotNull ItemIdentity itemId, long semantics) {
        StructureRows.validateForestRowId(rowId);
        this.myRowId = rowId;
        this.myItemId = itemId;
        this.mySemantics = semantics;
    }

    @Override
    public long getRowId() {
        return this.myRowId;
    }

    @Override
    @NotNull
    public ItemIdentity getItemId() {
        return this.myItemId;
    }

    @Override
    public long getSemantics() {
        return this.mySemantics;
    }

    @Override
    @Nullable
    public <I> I getItem(@NotNull Class<I> itemClass) {
        return null;
    }

    public String toString() {
        return CoreItemTypes.simplifyType(this.myItemId.toString()) + ':' + this.mySemantics;
    }

    static StructureRow copy(StructureRow row) {
        return row instanceof ShallowRow ? row : new ShallowRow(row.getRowId(), row.getItemId(), row.getSemantics());
    }
}

