/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.i18n;

import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.i18n.I18n;
import com.almworks.jira.structure.api.util.CallableE;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class JiraI18n
implements I18n {
    private final I18nHelper myHelper;

    public JiraI18n(I18nHelper helper) {
        this.myHelper = helper;
    }

    @Override
    public String getText(String key, Object ... parameters) {
        return this.myHelper.getText(key, (Object)parameters);
    }

    @Override
    public Locale getLocale() {
        return this.myHelper.getLocale();
    }

    public static I18n forCurrentUser() {
        return JiraI18n.create(null, StructureAuth.getUser());
    }

    @NotNull
    public static I18n create(final @Nullable Locale locale, final @Nullable ApplicationUser user) {
        final I18nHelper.BeanFactory factory = ComponentAccessor.getI18nHelperFactory();
        if (factory == null) {
            return new DummyI18n();
        }
        return JiraComponents.withThreadContextClassLoaderOf(factory, new CallableE<JiraI18n, RuntimeException>(){

            @Override
            public JiraI18n call() {
                I18nHelper helper = locale != null || user == null ? factory.getInstance(locale != null ? locale : StructureUtil.getJiraDefaultLocale()) : factory.getInstance(user);
                return new JiraI18n(helper);
            }
        });
    }

    private static class DummyI18n
    implements I18n {
        private DummyI18n() {
        }

        @Override
        public String getText(String key, Object ... parameters) {
            return key + ' ' + Arrays.toString(parameters);
        }

        @Override
        public Locale getLocale() {
            return Locale.ENGLISH;
        }
    }
}

