/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.generator.util;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.RowValues;
import com.almworks.jira.structure.api.attribute.RowValuesWithUpdateChecker;
import com.almworks.jira.structure.api.attribute.StructureAttributeService;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.almworks.jira.structure.api.generator.StructureGenerator;
import com.almworks.jira.structure.api.generator.util.RecordingAttributeUpdateChecker;
import com.atlassian.jira.util.lang.Pair;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GenerationUtil {
    @NotNull
    public static Pair<RowValues, RecordingAttributeUpdateChecker> getValuesFromSubjectForest(StructureGenerator.GenerationContext context, AttributeSpec<?> spec, LongList rows, StructureAttributeService attributeService) {
        return GenerationUtil.getValuesFromSubjectForest(context, Collections.singletonList(spec), rows, attributeService);
    }

    @NotNull
    public static Pair<RowValues, RecordingAttributeUpdateChecker> getValuesFromSubjectForest(StructureGenerator.GenerationContext context, Collection<? extends AttributeSpec<?>> specs, LongList rows, StructureAttributeService attributeService) {
        ForestSpec transformedSpec = context.getForestSpecBeingTransformed();
        RowValuesWithUpdateChecker valuesWithChecker = transformedSpec != null ? attributeService.getAttributeValuesWithUpdateChecker(transformedSpec, rows, specs) : attributeService.getAttributeValuesWithUpdateChecker(context.previewForest(), rows, specs, context.getForestSpec());
        RecordingAttributeUpdateChecker checker = new RecordingAttributeUpdateChecker(valuesWithChecker.getUpdateChecker());
        context.addUpdateChecker(checker);
        return Pair.of((Object)valuesWithChecker.getRowValues(), (Object)checker);
    }

    private GenerationUtil() {
    }
}

