/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AttributeCachingStrategy;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextDependency;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.TrailItemSet;
import com.almworks.jira.structure.api.attribute.loader.builder.BaseAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.builder.RowPreloadFunction;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSingleRowAttributeLoader<T>
extends BaseAttributeLoader<T>
implements SingleRowAttributeLoader<T> {
    @NotNull
    private final BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> myLoadingFunction;
    @Nullable
    private final RowPreloadFunction myPreloadFunction;
    private final boolean myWholeForestDependent;

    public BaseSingleRowAttributeLoader(@NotNull AttributeSpec<T> attributeSpec, @Nullable Set<AttributeSpec<?>> dependencies, @Nullable Set<AttributeContextDependency> contextDependencies, @Nullable AttributeCachingStrategy cachingStrategy, @Nullable TrailItemSet globalTrail, @NotNull BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> loadingFunction, @Nullable RowPreloadFunction preloadFunction, boolean wholeForestDependent) {
        super(attributeSpec, dependencies, contextDependencies, cachingStrategy, globalTrail);
        this.myLoadingFunction = loadingFunction;
        this.myPreloadFunction = preloadFunction;
        this.myWholeForestDependent = wholeForestDependent;
    }

    @Override
    @Nullable
    public AttributeValue<T> loadValue(@NotNull StructureRow row, @NotNull SingleRowAttributeContext context) {
        return this.myLoadingFunction.apply(row, context);
    }

    @Override
    public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
        if (this.myPreloadFunction != null) {
            this.myPreloadFunction.preload(rowIds, forest, context);
        }
    }

    @Override
    public boolean isWholeForestDependent() {
        return this.myWholeForestDependent;
    }
}

