package com.almworks.jira.structure.api.row;

/**
 * These values may be used to optimize the access to {@link StructureRow}, based on whether the client code is going to use the
 * {@link StructureRow#getItem} method or not, and whether it is important that the current user has access to that item.
 *
 * @see RowRetriever
 */
public enum ItemAccessMode {
  /**
   * The provided structure row will exhibit normal behavior. When coming from a regular row source, it means that when {@link StructureRow#getItem}
   * is called, the user's access is going to be checked and the method will return {@code null} if the user has no access.
   */
  NORMAL_ACCESS,

  /**
   * The caller indicates that {@link StructureRow#getItem} is not going to be called on the received structure row.
   * It's up to the implementation to decide what to do. The result of {@link StructureRow#getItem}, should it be called, is undefined.
   */
  ITEM_NOT_NEEDED,

  /**
   * The caller indicates that {@link StructureRow#getItem} will be called, but the implementation should skip whatever access check it might
   * do. This is typically done when the permission to access the item by the current user has been already established.
   */
  SKIP_ACCESS_CHECK
}
