package com.almworks.jira.structure.api.query;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * Parses a {@link StructureQuery structure query} expressed in the Structured JQL language. The syntax of 
 * the language is the same as of the corresponding argument of the {@code structure()} JQL function
 * bundled with the Structure plugin. See plugin documentation for more details on the syntax.
 * */
@PublicApi
public interface StructureQueryParser {
  /** 
   * Parses {@code query} and returns the corresponding {@link StructureQuery}. The returned object will
   * yield {@code query} when {@link StructureQuery#getQueryString()} is called.
   * 
   * @throws NullPointerException if {@code query} is {@code null} 
   * @throws StructureException if the query is not well-formed; call {@link StructureException#getLocalizedMessage()} 
   *  or {@link StructureException#getLocalizedMessage}
   *  to get a human-readable parse error message. 
   * */
  @NotNull
  StructureQuery parse(@NotNull String query) throws StructureException;
}
