package com.almworks.jira.structure.api.lifecycle;

import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;

@Internal
public interface CachingComponent {
  void clearCaches();

  /**
   * Clear all cached data associated with the specified user.
   * 
   * If the component doesn't store any data associated with user (i.e., user is not a part of a cache entry key),
   * this method mustn't do anything.
   * 
   * If the component cannot selectively clear entries for one user, it might clear more, but it must ensure
   * that all related entries are cleared.
   * 
   * @param user the user for which to clear the cached data
   * */
  @Deprecated
  void clearUserCaches(@NotNull ApplicationUser user);

  /**
   * Clear all cached data associated with the specified user key.
   *
   * If the component doesn't store any data associated with user (i.e., user is not a part of a cache entry key),
   * this method mustn't do anything.
   *
   * If the component cannot selectively clear entries for one user, it might clear more, but it must ensure
   * that all related entries are cleared.
   *
   * When default implementation is overridden it should guarantee that cache will be cleared even user associated with the key
   * doesn't exist, that might happen in case of changing user key during anonymization for the user that was created prior Jira 8.3
   *
   * @param userKey the user key for which to clear the cached data
   * */
  default void clearUserCaches(@NotNull String userKey) {
    ApplicationUser user = StructureUtil.getUserByKey(userKey);
    if (user != null) {
      clearUserCaches(user);
    }
  }
}
