package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeLoader;

import java.util.function.Function;
import java.util.function.Supplier;

public class DerivedAttributeLoaderBuilder<T> extends ArbitraryDependenciesAttributeLoaderBuilder<T, DerivedAttributeLoaderBuilder<T>> {
  private Function<DerivedAttributeContext, AttributeValue<T>> myValueFunction;

  public DerivedAttributeLoaderBuilder<T> valueFunctionAV(Function<DerivedAttributeContext, AttributeValue<T>> valueFunction) {
    myValueFunction = valueFunction;
    return self();
  }

  public DerivedAttributeLoaderBuilder<T> valueFunctionAV(Supplier<AttributeValue<T>> valueFunction) {
    return valueFunctionAV(ctx -> valueFunction.get());
  }

  public DerivedAttributeLoaderBuilder<T> valueFunction(Function<DerivedAttributeContext, T> valueFunction) {
    return valueFunctionAV(ctx -> AttributeValue.ofNullable(valueFunction.apply(ctx)));
  }

  public DerivedAttributeLoaderBuilder<T> valueFunction(Supplier<T> valueFunction) {
    return valueFunctionAV(ctx -> AttributeValue.ofNullable(valueFunction.get()));
  }

  public DerivedAttributeLoader<T> build() {
    return new BaseDerivedAttributeLoader<>(
      notNull(myAttributeSpec, "attributeSpec"),
      nullableCollectionOfNonNulls(buildDependencies(), "dependencies"),
      nullableCollectionOfNonNulls(buildContextDependencies(), "contextDependencies"),
      myCachingStrategy,
      myGlobalTrail,
      notNull(myValueFunction, "valueFunction")
    );
  }
}
