package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.builder.ItemAttributeLoaderBuilder;
import com.almworks.jira.structure.api.item.CoreItemTypes;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;

@PublicApi
public final class AttributeLoaders extends SharedAttributeLoaders {
  public static <T> ItemAttributeLoaderBuilder<T, Issue> issueLoader(AttributeSpec<T> spec) {
    return itemLoader(spec).itemType(CoreItemTypes.ISSUE).itemClass(Issue.class);
  }

  private AttributeLoaders() {
  }
}
