package com.almworks.jira.structure.api.item;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicSpi
public interface StructureItemType<T> {
  /**
   * Does not check for permissions.
   * @param itemId
   * @return
   */
  @Nullable
  T accessItem(@NotNull ItemIdentity itemId);

  boolean isVisible(@NotNull T item, @Nullable ApplicationUser user); // or itemId?
}
