package com.almworks.jira.structure.api.generator.util;

import com.almworks.jira.structure.api.generator.UpdateChecker;

public class TimedUpdateChecker implements UpdateChecker {
  private final long myNanoNow;
  private final long myIntervalNs;

  public TimedUpdateChecker(long intervalNs) {
    myNanoNow = System.nanoTime();
    myIntervalNs = intervalNs;
  }

  @Override
  public boolean hasUpdate() {
    return System.nanoTime() - myNanoNow >= myIntervalNs;
  }
}
