package com.almworks.jira.structure.api.generator.util;

import com.almworks.integers.LongArray;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.attribute.AttributeUpdateChecker;
import com.almworks.jira.structure.api.generator.UpdateChecker;
import com.almworks.jira.structure.api.row.StructureRow;

public class RecordingAttributeUpdateChecker implements UpdateChecker {
  private final AttributeUpdateChecker myAttributeChecker;
  private final WritableLongList myRecordedRows = new LongArray();
  private volatile boolean myRecording = true;

  public RecordingAttributeUpdateChecker(AttributeUpdateChecker attributeChecker) {
    myAttributeChecker = attributeChecker;
  }

  public void record(StructureRow row) {
    if (row != null && row.getRowId() != 0) {
      record(row.getRowId());
    }
  }

  public void record(long rowId) {
    if (!myRecording) {
      throw new IllegalStateException("mutating " + this + " after hasUpdate() was called");
    }
    myRecordedRows.add(rowId);
  }

  @Override
  public boolean hasUpdate() {
    myRecording = false;
    return myAttributeChecker.hasUpdate(myRecordedRows);
  }
}
