package com.almworks.jira.structure.api.effector.process;

import com.almworks.jira.structure.api.effect.StoredEffect;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.util.I18nText;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * Information about a single effect applied by an effector process.
 */
@PublicApi
public interface EffectRecord {
  /**
   * @return the ID of the process that applied the effect
   */
  long getProcessId();

  /**
   * @return the effect's success message or error message
   * @see #isError()
   */
  @NotNull
  I18nText getEffectMessage();

  /**
   * @return {@code false} if the effect was successfully applied, {@code true}
   * if there was an error
   */
  boolean isError();

  /**
   * @return the description of an effect that would undo this change
   */
  @Nullable
  StoredEffect getUndoEffect();

  /**
   * @return the list of item IDs for the items changed by this effect
   */
  @NotNull
  List<ItemIdentity> getAffectedItems();

  /**
   * @return the timestamp when this effect was applied
   */
  long getTimestamp();

  /**
   * @return the index of this effect in the process' preview
   */
  int getPreviewIndex();
}
