package com.almworks.jira.structure.api.effector;

/**
 * An exception that an {@link Effector} is allowed to throw to indicate that
 * it is currently unavailable.
 */
public class EffectorUnavailableException extends Exception {
  private final String myLocalizedMessage;

  public EffectorUnavailableException(String message) {
    this(message, message);
  }

  public EffectorUnavailableException(String message, String localizedMessage) {
    super(message);
    myLocalizedMessage = localizedMessage;
  }

  @Override
  public String getLocalizedMessage() {
    return myLocalizedMessage;
  }
}
