package com.almworks.jira.structure.api.attribute.loader.delegate;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeLoader;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;

public class DelegatingPropagateAttributeLoader<T> extends DelegatingRowAttributeLoader<T, PropagateAttributeLoader<T>> implements PropagateAttributeLoader<T> {
  public DelegatingPropagateAttributeLoader(@NotNull PropagateAttributeLoader<T> loader) {
    super(loader);
  }

  @Override
  @Nullable
  public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent context) {
    return delegate().loadChildren(parentValue, context);
  }

  @Override
  public boolean isLoadingSuperRoot() {
    return delegate().isLoadingSuperRoot();
  }
}
