package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public abstract class ArbitraryDependenciesAttributeLoaderBuilder<T, S extends ArbitraryDependenciesAttributeLoaderBuilder<T, S>>
  extends AttributeLoaderBuilder<T, S>
{
  private Set<AttributeSpec<?>> myDependencies;

  public S dependencies(@Nullable AttributeSpec<?>... dependencies) {
    if (dependencies != null) {
      for (AttributeSpec<?> dependency : dependencies) {
        dependency(dependency);
      }
    }
    return self();
  }

  public S dependency(@Nullable AttributeSpec<?> dependency) {
    if (dependency != null) {
      Set<AttributeSpec<?>> dependencies = myDependencies;
      if (dependencies == null) {
        myDependencies = dependencies = new LinkedHashSet<>();
      }
      dependencies.add(dependency);
    }
    return self();
  }

  @Nullable
  protected Set<AttributeSpec<?>> buildDependencies() {
    Set<AttributeSpec<?>> dependencies = myDependencies;
    if (dependencies == null) return null;
    if (dependencies.isEmpty()) return Collections.emptySet();
    return Collections.unmodifiableSet(new LinkedHashSet<>(dependencies));
  }
}
