package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * <p>The base context interface for all row-based attribute loaders.</p>
 *
 * @see RowAttributeLoader
 */
@PublicApi
public interface RowAttributeContext extends AttributeLoaderContext {
  /**
   * Returns the row currently being loaded.
   *
   * @return the loaded row
   */
  @NotNull
  StructureRow getRow();
}
