package com.almworks.jira.structure.api.effector.process;

import com.almworks.jira.structure.api.effect.StoredEffect;
import com.almworks.jira.structure.api.util.I18nText;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * <p><code>EffectorPreview</code> stores the results of an effector run in the "preview" mode.</p>
 */
@PublicApi
public interface EffectorPreview {

  /**
   * Returns a list of errors that prevent effector from applying.
   */
  @NotNull
  List<I18nText> getErrors();

  /**
   * Returns a list of effects that will be applied in case of the user confirmation.
   */
  @NotNull
  List<StoredEffect> getPreviewEffects();
}