package com.almworks.jira.structure.api.effector;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.RowValues;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.process.ProgressSink;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * A context object for {@link Effector#getEffectorFunction(Map, EffectorContext)},
 * which allows the effector to require attribute values and inspect the
 * {@link ForestSpec forest spec} being processed.
 */
@PublicApi
public interface EffectorContext {
  /**
   * <p>Allows the effector to require an attribute that it needs in order to
   * produce effects.
   *
   * <p>Required attribute values for all processed rows, if available,
   * will be passed to {@link EffectorFunction#produceEffects(ItemForest, RowValues, EffectCollector, ProgressSink)}.
   *
   * @param attribute the attribute spec
   */
  void requireAttribute(@NotNull AttributeSpec<?> attribute);

  /**
   * Returns the forest spec processed by the current effector invocation.
   */
  @NotNull
  ForestSpec getForestSpec();
}
