package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.atlassian.annotations.PublicSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * <p>Derived loaders calculate the attribute value based only on the attribute dependencies. The dependencies are loaded by some other
 * loaders and may be item or row based, or they may be other derived attributes.</p>
 *
 * <p>Values calculated by derived attribute loaders are stored in the per-item cache only if they depend on other per-item attributes, otherwise
 * they are stored in the per-forest cache.</p>
 *
 * <p><strong>The loader must be a stable function, based on the dependency values.</strong> It must not depend on any other inputs, and should
 * provide the same result for the same inputs every time: {@code V(row) = DERIVED(dependencies(row))}.</p>
 *
 * @param <T> type of the loaded value
 *
 * @see AttributeLoader
 */
@PublicSpi
public interface DerivedAttributeLoader<T> extends AttributeLoader<T> {
  /**
   * <p>Performs the loading.</p>
   *
   * <p>If the value is missing or empty, the loader should return {@link AttributeValue#undefined()}. If for some reason this loader
   * is not applicable for the given row, it should return {@code null}.</p>
   *
   * @param context loading context
   * @return the calculated value
   */
  @Nullable
  AttributeValue<T> loadValue(@NotNull DerivedAttributeContext context);
}
