package com.almworks.jira.structure.api.util;

public class ToString {
  public static final String BEGIN = "{";
  public static final String EQ = "=";
  public static final String SEP = ",";
  public static final String END = "}";
  
  public static StringBuilder begin(String objName) {
    return new StringBuilder().append(objName).append(BEGIN);
  }
  
  public static StringBuilder append(StringBuilder toString, String name, int value) {
    return toString.append(name).append(EQ).append(value).append(SEP);
  }

  public static StringBuilder append(StringBuilder toString, String name, long value) {
    return toString.append(name).append(EQ).append(value).append(SEP);
  }

  public static StringBuilder append(StringBuilder toString, String name, boolean value) {
    return toString.append(name).append(EQ).append(value).append(SEP);
  }

  public static StringBuilder append(StringBuilder toString, String name, Object value) {
    return toString.append(name).append(EQ).append(value).append(SEP);
  }

  public static String end(StringBuilder toString) {
    int l = toString.length(), sl = SEP.length();
    if (l > sl && toString.subSequence(l - sl, l).equals(SEP)) {
      toString.setLength(l - sl);
    }
    toString.append(END);
    return toString.toString();
  }
}
