package com.almworks.jira.structure.api.util;

import com.atlassian.annotations.PublicSpi;

@PublicSpi
public interface RunnableE<E extends Exception> {
  void run() throws E;

  default RunnableE<E> andThen(RunnableE<? extends E> another) {
    RunnableE<E> first = this;
    return () -> {
      first.run();
      another.run();
    };
  }
}
