/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.structure.history;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.forest.raw.Forest;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HistoryEntry {
    private final long myStructure;
    private final int myVersion;
    private final int myPrevVersion;
    private final long myTimestamp;
    private final String myUserKey;
    @Nullable
    private final Long mySynchronizer;
    @NotNull
    private final List<Change> myChanges;

    public HistoryEntry(long structure, int version, int prevVersion, long timestamp, String userKey, @Nullable Long synchronizer, @NotNull List<Change> changes) {
        this.myStructure = structure;
        this.myVersion = version;
        this.myPrevVersion = prevVersion;
        this.myTimestamp = timestamp;
        this.myUserKey = StringUtils.isEmpty((CharSequence)userKey) ? null : userKey;
        this.mySynchronizer = synchronizer;
        this.myChanges = changes;
    }

    public long getStructure() {
        return this.myStructure;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public int getPrevVersion() {
        return this.myPrevVersion;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public String getUserKey() {
        return this.myUserKey;
    }

    @Nullable
    public Long getSynchronizer() {
        return this.mySynchronizer;
    }

    @NotNull
    public List<Change> getChanges() {
        return this.myChanges;
    }

    public String toString() {
        return "HistoryEntry{myStructure=" + this.myStructure + ", myVersion=" + this.myVersion + ", myPrevVersion=" + this.myPrevVersion + ", myTimestamp=" + this.myTimestamp + ", myUserKey='" + this.myUserKey + '\'' + ", mySynchronizer=" + this.mySynchronizer + ", myChanges=" + this.myChanges + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryEntry that = (HistoryEntry)o;
        return this.myStructure == that.myStructure && this.myVersion == that.myVersion && this.myPrevVersion == that.myPrevVersion && this.myTimestamp == that.myTimestamp && Objects.equals(this.myUserKey, that.myUserKey) && Objects.equals(this.mySynchronizer, that.mySynchronizer) && Objects.equals(this.myChanges, that.myChanges);
    }

    public int hashCode() {
        return Objects.hash(this.myStructure, this.myVersion, this.myPrevVersion, this.myTimestamp, this.myUserKey, this.mySynchronizer, this.myChanges);
    }

    public static final class Change {
        private final Operation myOperation;
        private final Forest myForest;
        private final LongList myPathFrom;
        private final LongList myAfterFrom;
        private final LongList myPathTo;
        private final LongList myAfterTo;
        private final int myDirection;
        private final LongList myOriginalRows;

        public Change(Operation operation, Forest forest, LongList pathFrom, LongList afterFrom, LongList pathTo, LongList afterTo, int direction, LongList originalRows) {
            this.myOperation = operation;
            this.myForest = forest;
            this.myPathFrom = pathFrom;
            this.myAfterFrom = afterFrom;
            this.myPathTo = pathTo;
            this.myAfterTo = afterTo;
            this.myDirection = direction;
            this.myOriginalRows = originalRows;
        }

        public Operation getOperation() {
            return this.myOperation;
        }

        public Forest getForest() {
            return this.myForest;
        }

        public LongList getPathFrom() {
            return this.myPathFrom;
        }

        public LongList getAfterFrom() {
            return this.myAfterFrom;
        }

        public LongList getPathTo() {
            return this.myPathTo;
        }

        public LongList getAfterTo() {
            return this.myAfterTo;
        }

        public int getDirection() {
            return this.myDirection;
        }

        public LongList getOriginalRows() {
            return this.myOriginalRows;
        }

        public String toString() {
            return "Change{myOperation=" + (Object)((Object)this.myOperation) + ", myForest=" + this.myForest + ", myPathFrom=" + this.myPathFrom + ", myAfterFrom=" + this.myAfterFrom + ", myPathTo=" + this.myPathTo + ", myAfterTo=" + this.myAfterTo + ", myDirection=" + this.myDirection + ", myOriginalRows=" + this.myOriginalRows + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            return this.myDirection == change.myDirection && this.myOperation == change.myOperation && Objects.equals(this.myForest, change.myForest) && Objects.equals(this.myPathFrom, change.myPathFrom) && Objects.equals(this.myAfterFrom, change.myAfterFrom) && Objects.equals(this.myPathTo, change.myPathTo) && Objects.equals(this.myAfterTo, change.myAfterTo) && Objects.equals(this.myOriginalRows, change.myOriginalRows);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myOperation, this.myForest, this.myPathFrom, this.myAfterFrom, this.myPathTo, this.myAfterTo, this.myDirection, this.myOriginalRows});
        }
    }

    public static enum Operation {
        ADD("add"),
        COPY("copy"),
        MOVE("move"),
        REMOVE("remove");

        private final String myExternalName;

        private Operation(String externalName) {
            this.myExternalName = externalName;
        }

        public String getExternalName() {
            return this.myExternalName;
        }

        public static Operation forExternalName(String externalName) {
            for (Operation type : Operation.values()) {
                if (!type.myExternalName.equals(externalName)) continue;
                return type;
            }
            return null;
        }
    }
}

