/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item.generic;

import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.StructurePluginHelper;
import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.item.BulkAccessCheckingItemType;
import com.almworks.jira.structure.api.item.CreatableItemType;
import com.almworks.jira.structure.api.item.DeadItemsCheckingItemType;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemIdentitySet;
import com.almworks.jira.structure.api.item.StructureItemType;
import com.almworks.jira.structure.api.item.StructureOwnedItemType;
import com.almworks.jira.structure.api.item.UpdatableItemType;
import com.almworks.jira.structure.api.item.generic.GenericItem;
import com.almworks.jira.structure.api.item.generic.GenericItemManager;
import com.almworks.jira.structure.api.item.generic.GenericItemService;
import com.almworks.jira.structure.api.row.DummyRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.ModuleDescriptor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class GenericItemType
implements StructureItemType<GenericItem>,
CreatableItemType,
UpdatableItemType,
StructureOwnedItemType,
DeadItemsCheckingItemType,
BulkAccessCheckingItemType {
    public static final long NEW_ITEM_ID = Long.MAX_VALUE;
    private final GenericItemService myGenericItemService;
    private final GenericItemManager myGenericItemManager;
    private final StructurePluginHelper myHelper;
    private volatile String myItemType;

    public GenericItemType(GenericItemService genericItemService, GenericItemManager genericItemManager, StructurePluginHelper helper) {
        this.myGenericItemService = genericItemService;
        this.myGenericItemManager = genericItemManager;
        this.myHelper = helper;
    }

    @Internal
    public void init(ModuleDescriptor descriptor) {
        if (this.myItemType == null) {
            this.myItemType = descriptor.getCompleteKey();
        }
    }

    @Override
    @Nullable
    public GenericItem accessItem(@NotNull ItemIdentity itemId) {
        if (this.myItemType.equals(itemId.getItemType()) && itemId.isLongId() && itemId.getLongId() != Long.MAX_VALUE) {
            return this.myGenericItemManager.getItem(itemId);
        }
        return null;
    }

    @Override
    public boolean isVisible(@NotNull GenericItem item, @Nullable ApplicationUser user) {
        return this.myGenericItemManager.isVisible(item, user);
    }

    @Override
    public StructureRow createDummyRow(long rowId, long semantics, Map<String, Object> values, ErrorCollection errors) throws StructureException {
        String name = this.getName(values, errors);
        if (name == null) {
            return null;
        }
        GenericItem genericItem = GenericItem.named(name).build();
        GenericItemService.CreateValidationResult validationResult = this.myGenericItemService.validateCreate(this.myItemType, genericItem);
        if (validationResult.isValid()) {
            return new DummyRow(rowId, ItemIdentity.longId(this.myItemType, Long.MAX_VALUE), semantics, genericItem);
        }
        this.handleInvalidResult(validationResult, errors);
        return null;
    }

    @Override
    public ItemIdentity createItem(Map<String, Object> values, ErrorCollection errors) throws StructureException {
        String name = this.getName(values, errors);
        if (name == null) {
            return null;
        }
        GenericItem.Builder builder = GenericItem.named(name);
        this.readItemValues(builder, values, null, errors);
        if (errors.hasAnyErrors()) {
            return null;
        }
        GenericItem genericItem = builder.build();
        GenericItemService.CreateValidationResult validationResult = this.myGenericItemService.validateCreate(this.myItemType, genericItem);
        GenericItemService.GenericItemResult createResult = this.myGenericItemService.create(validationResult);
        if (createResult.isValid()) {
            return createResult.getItemId();
        }
        this.handleInvalidResult(createResult, errors);
        return null;
    }

    @Override
    public void updateItem(ItemIdentity itemId, Map<String, Object> values, ErrorCollection errors) throws StructureException {
        if (!this.myItemType.equals(itemId.getItemType())) {
            throw StructureErrors.INVALID_PARAMETER.withMessage(itemId + " is not a " + this.myItemType + " ID");
        }
        GenericItem existing = this.accessItem(itemId);
        if (existing == null || !this.isVisible(existing, StructureAuth.getUser())) {
            throw StructureErrors.ITEM_NOT_EXISTS_OR_NOT_ACCESSIBLE.forItem(itemId).withMessage(itemId + " is not found or not accessible");
        }
        GenericItem.Builder builder = GenericItem.copy(existing);
        if (values.containsKey("summary")) {
            String name = this.getName(values, errors);
            if (name == null) {
                return;
            }
            builder.setName(name);
        }
        this.readItemValues(builder, values, existing, errors);
        if (errors.hasAnyErrors()) {
            return;
        }
        GenericItem genericItem = builder.build();
        GenericItemService.UpdateValidationResult validationResult = this.myGenericItemService.validateUpdate(itemId, genericItem);
        GenericItemService.GenericItemResult updateResult = this.myGenericItemService.update(validationResult);
        if (!updateResult.isValid()) {
            this.handleInvalidResult(updateResult, errors);
        }
    }

    @Override
    @NotNull
    public ItemIdentity getOwnedItem(@NotNull ItemIdentity itemId, long structureId, boolean copyIfSame) throws StructureException {
        if (this.myItemType.equals(itemId.getItemType()) && itemId.isLongId()) {
            return this.myGenericItemManager.getOwnedItem(itemId, structureId, copyIfSame);
        }
        return itemId;
    }

    @Override
    public void filterDead(ItemIdentitySet items, ItemIdentitySet deadCollector) {
        for (LongIterator it : items.longIds(this.myItemType)) {
            ItemIdentity itemId = ItemIdentity.longId(this.myItemType, it.value());
            GenericItem genericItem = this.accessItem(itemId);
            if (genericItem != null) continue;
            deadCollector.add(itemId);
        }
    }

    @Override
    public void filterInaccessible(ItemIdentitySet items, ApplicationUser user, boolean overrideSecurity, ItemIdentitySet inaccessibleCollector) {
        for (LongIterator it : items.longIds(this.myItemType)) {
            ItemIdentity itemId;
            GenericItem item;
            if (it.value() == Long.MAX_VALUE || (item = this.accessItem(itemId = ItemIdentity.longId(this.myItemType, it.value()))) != null && (overrideSecurity || this.isVisible(item, user))) continue;
            inaccessibleCollector.add(itemId);
        }
    }

    @Nullable
    private String getName(Map<String, Object> values, ErrorCollection errors) {
        String name = StructureUtil.getSingleParameter(values, "summary");
        if (StringUtils.isBlank((String)name)) {
            errors.addError("summary", this.myHelper.getI18n().getText("s.ext.it.item.error.name-blank"));
            return null;
        }
        return name;
    }

    protected void readItemValues(GenericItem.Builder builder, Map<String, Object> values, GenericItem existing, ErrorCollection errors) {
        if (values == null) {
            return;
        }
        if (values.containsKey("description")) {
            builder.setDescription(StructureUtil.getSingleParameter(values, "description"));
        }
        if (values.containsKey("params")) {
            Map<String, Object> params = StructureUtil.toMap(values.get("params"));
            if (params == null) {
                builder.setParameters(null);
            } else {
                params.forEach(builder::setParameter);
            }
        }
    }

    private void handleInvalidResult(GenericItemService.ExceptionSupportResult result, ErrorCollection errors) throws StructureException {
        if (result.getException() != null) {
            throw result.getException();
        }
        errors.addErrorCollection(result.getErrorCollection());
    }
}

