/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.basic.AbstractScanningLoader;
import com.almworks.jira.structure.api.attribute.loader.basic.NumberAccumulator;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanningNumberSumLoader
extends AbstractScanningLoader<Number> {
    private final AttributeSpec<Number> myDependency;

    public ScanningNumberSumLoader(@NotNull AttributeSpec<Number> spec, AttributeSpec<Number> dependency) {
        super(spec);
        this.myDependency = dependency;
    }

    @Override
    @Nullable
    public Set<AttributeSpec<?>> getAttributeDependencies() {
        return Collections.singleton(this.myDependency);
    }

    @Override
    @Nullable
    protected Number loadValueForPassingRow(@Nullable Number precedingValue, ScanningAttributeContext context) {
        NumberAccumulator acc = new NumberAccumulator();
        acc.add(precedingValue);
        acc.add(context.getDependencyValue(this.myDependency));
        return acc.toNumber();
    }
}

