package com.almworks.jira.structure.api.sync;

import com.almworks.jira.structure.api.util.MapObject;

import java.util.List;

/**
 * A {@link StructureSynchronizer} that is able to undo synchronizer actions.
 * To enable a synchronizer for undoing actions, the actions that are applied during {@link StructureSynchronizer#sync}
 * or {@link StructureSynchronizer#resync} should be recorded in {@link SyncAuditLog}. 
 * The synchronizer that implements this interface will then receive these actions in the same format in {@link #undo}.
 * It is up to the synchronizer author to supply sufficient information for undo in the actions recorded in {@link SyncAuditLog}.
 * 
 * @author sank
 * */
public interface UndoingSynchronizer extends StructureSynchronizer {
  String FAILURE_REASON_UNKNOWN_ACTION = "unknownAction";
  
  /**
   * Undoes the specified actions, performing zero or more undo actions.
   * Returns the performed undo actions. They should be in the same format as the specified actions.
   * */
  List<MapObject> undo(List<MapObject> actions);
}
