package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.util.I18nText;
import org.jetbrains.annotations.Nullable;

/**
 * <p><b>ProcessUIController</b> allows configure UI for the process status page.</p>
 *
 * <p>If you know processId, you can access its UI controller using {@link ProcessHandleManager#getUIController(Long)} method.</p>
 */
public interface ProcessUIController {
  void setParameters(@Nullable ProcessDisplayParameters parameters);

  /**
   * Updates process progress information
   * @param activity Current activity description, {@code null} to keep activity unchanged
   * @param percentComplete Completion percentage, 0 to 100, or -1 for unknown/indeterminate, or {@code null} too keep percentage unchanged
   * @throws IllegalArgumentException if {@code percentComplete} is less than -1 or greater than 100
   */
  void setProgress(@Nullable I18nText activity, @Nullable Integer percentComplete);
}
