package com.almworks.jira.structure.api.process;

import org.jetbrains.annotations.NotNull;

/**
 * <p><b>ProcessFeedback</b> allows communication between process owner and process itself.</p>
 *
 * <p>If you know processId, you can access its feedback using {@link ProcessHandleManager#getFeedback(Long)} method.</p>
 */
public interface ProcessFeedback {
  /**
   * Updates process status
   * @param status New status to be set
   * todo state that it's not exception-free
   */
  void setStatus(@NotNull ProcessStatus status);

  /**
   * @return {@code true} if the process has been asked to stop with {@link ProcessInfo#cancel()}
   */
  boolean isCancelled();
}
