package com.almworks.jira.structure.api.planningtask;

import com.almworks.jira.structure.api.agile.Sprint;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

@Internal
public interface PlanningTask {
  @Nullable
  String getSummary();
  @Nullable
  String getDescription();
  @Nullable
  ApplicationUser getAssignee();
  @Nullable
  LocalDate getDueDate();
  @Nullable
  Long getOriginalEstimate();
  @Nullable
  Long getRemainingEstimate();
  @Nullable
  String getEnvironment();
  @Nullable
  ApplicationUser getReporter();
  @Nullable
  Priority getPriority();
  @Nullable
  IssueType getIssueType();
  @Nullable
  Project getProject();
  @Nullable
  List<String> getLabels();
  @Nullable
  List<Version> getAffectedVersions();
  @Nullable
  List<Version> getFixVersions();
  @Nullable
  List<ProjectComponent> getComponents();
  @Nullable
  Sprint getSprint();
  @Nullable
  String getTextCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  Date getDateTimeCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  Double getNumberCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  LocalDate getDateCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  List<String> getLabelsCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  Project getProjectCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  Version getSingleVersionCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  List<Version> getMultiVersionCustomFieldValue(@NotNull CustomField customField);
  @Nullable
  ApplicationUser getSingleUserCustomFieldValue(@NotNull CustomField customField);
}
