package com.almworks.jira.structure.api.item;

import com.atlassian.annotations.PublicSpi;

import java.util.Collection;
import java.util.function.BiConsumer;

@PublicSpi
public interface BulkAccessibleItemType<T> {
  /*
   * Bulk retrieves items for requested item identities and passes available ones to consumer.
   *
   * Does not check for permissions.
   * Successfully resolved items are passed to consumer together with the corresponding item identity.
   * Items that were not successfully resolved are ignored.
   * Item identities that are not represented by this item type are ignored.
   */
  void accessItems(Collection<ItemIdentity> itemIdentities, BiConsumer<ItemIdentity, T> consumer);
}
