package com.almworks.jira.structure.api.forest.item;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

@PublicApi
public interface ItemListBuilder<B extends ItemListBuilder<B>> {
  /**
   * Appends a new row with the given item identity.
   *
   * @param itemId Item identity
   *
   * @return this instance
   */
  @NotNull
  B nextRow(@NotNull ItemIdentity itemId);

  /**
   * Appends a new row with the given item identity and semantics.
   *
   * @param itemId Item identity
   * @param semantics Semantics code. Semantics is still work in progress, and passing any value other
   * than 0 may result in undefined behavior.
   *
   * @return this instance
   */
  @NotNull
  B nextRow(@NotNull ItemIdentity itemId, long semantics);
}
