package com.almworks.jira.structure.api.forest;

import com.almworks.integers.LongLongMap;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

@PublicApi
public interface ForestSourceHealthStatus {
  ForestSourceHealthStatus HEALTHY = new ForestSourceHealthStatus() {
    @Override
    public boolean isStopped() {
      return false;
    }

    @NotNull
    @Override
    public LongLongMap getGenerationTimes() {
      return LongLongMap.EMPTY;
    }

    @NotNull
    @Override
    public LongLongMap getHitLimits() {
      return LongLongMap.EMPTY;
    }
  };

  boolean isStopped();

  @NotNull
  LongLongMap getGenerationTimes();

  @NotNull
  LongLongMap getHitLimits();
}
