package com.almworks.jira.structure.api.event;

import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;

/**
 * Event indicating a structure item has been converted.
 */
public class StructureItemConvertedEvent {
  private final long myStructureId;
  private final ItemIdentity mySourceItemId;
  private final ItemIdentity myTargetItemId;

  public StructureItemConvertedEvent(long structureId, @NotNull ItemIdentity sourceItemId, @NotNull ItemIdentity targetItemId) {
    myStructureId = structureId;
    mySourceItemId = sourceItemId;
    myTargetItemId = targetItemId;
  }

  public long getStructureId() {
    return myStructureId;
  }

  @NotNull
  public ItemIdentity getSourceItemId() {
    return mySourceItemId;
  }

  @NotNull
  public ItemIdentity getTargetItemId() {
    return myTargetItemId;
  }
}
