package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * <p>The context interface for item attribute loaders.</p>
 *
 * @see ItemAttributeLoader
 */
@PublicApi
public interface ItemAttributeContext extends AttributeLoaderContext {
  /**
   * Returns the item being currently loaded, equal to the first parameter of {@link ItemAttributeLoader#loadValue}.
   *
   * @return item being loaded
   */
  @NotNull
  ItemIdentity getItemId();

  /**
   * Returns the object representing the loaded item.
   *
   * @param itemClass expected object type
   * @return the item being loaded, if it matches the expected type, or {@code null} if it cannot be provided
   * @see StructureRow#getItem(Class)
   */
  @Nullable
  <I> I getItem(@NotNull Class<I> itemClass);
}
