package com.almworks.jira.structure.api.view;

/**
 * {@code ColumnDisplayMode} stores constants representing supported column display modes.
 * Display mode determines how columns are adjusted on the application panel.
 */
public final class ColumnDisplayMode {
  private ColumnDisplayMode() {
  }

  /**
   * Column sizes are automatically adjusted to fit their corresponding panel
   */
  public static final int AUTO_FIT = 1;

  /**
   * If columns no longer fit within the panel, a horizontal scroll bar will appear
   */
  public static final int SCROLLABLE = 2;

  /**
   * @return true if the given column display mode is supported
   */
  public static boolean isValid(int mode) {
    return mode == AUTO_FIT || mode == SCROLLABLE;
  }
}