/**
 * <p>This package and subpackages contain Structure API, which can be used to integrate with and extend Structure add-on for JIRA.</p>
 *
 * <p>The packages contains different types of classes:</p>
 * <ul>
 *   <li>To use Structure, make calls to API classes, marked with {@link com.atlassian.annotations.PublicApi}.</li>
 *   <li>To extend Structure's functionality, extend SPI classes, marked with {@link com.atlassian.annotations.PublicSpi}.</li>
 *   <li>There are classes marked {@link com.atlassian.annotations.Internal} &mdash; you can use those, but backwards
 *   compatibility is not guaranteed in minor updates.</li>
 * </ul>
 *
 * <p>You can read more about versioning and the distinction between the API, SPI and Internal classes in
 * <a href="http://wiki.almworks.com/display/structure/Structure+Developer%27s+Guide">Structure Developer's Guide</a>.</p>
 *
 * <p>
 *   All main services are available as injectable parameters
 *   or through {@link com.almworks.jira.structure.api.StructureComponents}.
 * </p>
 * <p>
 *   The following is the list of major services you might need to work with:
 * </p>
 * <ul>
 * <li>{@link com.almworks.jira.structure.api.structure.StructureManager} lets you create, find, update and delete
 * structures. Note that it does not provide access to the structures' content, only to the properties like name and
 * description.</li>
 * <li>{@link com.almworks.jira.structure.api.forest.ForestService} allows you to retrieve and update a structure's content.
 * It also can be used to transform structures or to run queries.</li>
 * <li>{@link com.almworks.jira.structure.api.folder.FolderManager} and {@link com.almworks.jira.structure.api.generator.GeneratorManager}
 * let you create and manage folders and generators.</li>
 * <li>Use {@link com.almworks.jira.structure.api.item.CoreIdentities} to create {@link com.almworks.jira.structure.api.item.ItemIdentity}
 * instances for issues and other well-known types.</li>
 * <li>{@link com.almworks.jira.structure.api.row.RowManager} lets you retrieve {@link com.almworks.jira.structure.api.row.StructureRow}
 *  by row ID and extract item ID from it.</li>
 * <li>Use {@link com.almworks.jira.structure.api.sync.StructureSyncManager} to install and configure synchronizers.</li>
 * <li>Use {@link com.almworks.jira.structure.api.view.StructureViewManager} to work with views.</li>
 * </ul>
 */
package com.almworks.jira.structure.api;