package com.almworks.jira.structure.api.item;

import com.almworks.jira.structure.api.error.StructureException;
import org.jetbrains.annotations.NotNull;

public interface StructureOwnedItemType {
  /**
   * Associate an item with a structure, or create a copy of the given item and associate the copy with the structure.
   * @param itemId The item ID.
   * @param structureId The structure ID.
   * @param copyIfSame Create a copy of the item even if it is already associated with the given structure.
   * @return The ID of the associated item.
   * @throws StructureException
   */
  @NotNull
  ItemIdentity getOwnedItem(@NotNull ItemIdentity itemId, long structureId, boolean copyIfSame) throws StructureException;
}
