package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.row.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

import static com.almworks.jira.structure.api.row.ItemAccessMode.NORMAL_ACCESS;

public class ManagerBackedItemForest implements ItemForest {
  @NotNull
  private final Forest myForest;

  @NotNull
  private final RowManager myRowManager;

  @Nullable
  private final ItemAccessMode myDefaultAccessMode;

  public ManagerBackedItemForest(@NotNull Forest forest, @NotNull RowManager rowManager) {
    this(forest, rowManager, NORMAL_ACCESS);
  }

  public ManagerBackedItemForest(@NotNull Forest forest, @NotNull RowManager rowManager, @Nullable ItemAccessMode defaultAccessMode) {
    myForest = forest;
    myRowManager = rowManager;
    myDefaultAccessMode = defaultAccessMode;
  }

  @NotNull
  @Override
  public Forest getForest() {
    return myForest;
  }

  @NotNull
  @Override
  public StructureRow getRow(long rowId, @NotNull ItemAccessMode access) throws MissingRowException {
    return myRowManager.getRow(rowId, getAccessMode(access));
  }

  @Override
  public void scanRows(@Nullable LongIterable rows, boolean sorted, @NotNull ItemAccessMode access, @Nullable LongCollector missingCollector,
    @NotNull Predicate<StructureRow> iteratee) throws MissingRowException
  {
    myRowManager.scanRows(rows, sorted, getAccessMode(access), missingCollector, iteratee);
  }

  private ItemAccessMode getAccessMode(@NotNull ItemAccessMode access) {
    // The mode passed with a specific call overrides the mode passed for the whole instance. Unless it is NORMAL_ACCESS, which is the default, and
    // which is used when you call the default method (getRow, scanRows) without the access mode parameter.
    // So in the case of NORMAL_ACCESS, the specific access mode does not override the whole instance mode.
    return access != NORMAL_ACCESS ? access : myDefaultAccessMode;
  }
  
  @Override
  public String toString() {
    return myForest.toFullString();
  }
}
