package com.almworks.jira.structure.api.backup;

import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface BackupReader {
  /**
   * Reads a section of the current element. {@code elementReader} is called for each element inside the section
   * when {@code BackupReader} reaches it. Reading stops on a section's end tag.
   *
   * @param elementReader reader of the elements inside the section; accepts current element name as a parameter
   */
  void readSection(@NotNull ElementReader elementReader);

  void skipSection();

  String getElementText();

  @Nullable
  String getAttributeValue(String localName);

  @FunctionalInterface
  interface ElementReader {
    void readElement(@NotNull String elementName);
  }
}
