package com.almworks.jira.structure.api.attribute.subscription;

import com.almworks.jira.structure.api.attribute.RowValues;
import com.almworks.jira.structure.api.pull.DataVersion;
import com.almworks.jira.structure.api.pull.VersionedDataUpdate;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class AttributeSubscriptionUpdate extends VersionedDataUpdate {
  private final boolean myFull;
  private final RowValues myValues;

  public AttributeSubscriptionUpdate(@NotNull DataVersion version, boolean full, RowValues values) {
    super(version);
    myFull = full;
    myValues = values;
  }

  public RowValues getValues() {
    return myValues;
  }

  @Override
  public boolean isFull() {
    return myFull;
  }

  @Override
  public boolean isEmpty() {
    return myValues == RowValues.EMPTY;
  }
}
