package com.almworks.jira.structure.api.attribute.loader.composition;

import com.almworks.jira.structure.api.attribute.loader.*;
import org.jetbrains.annotations.NotNull;

public enum LoaderType {
  PROPAGATE(PropagateAttributeLoader.class, 4),
  AGGREGATE(AggregateAttributeLoader.class, 4),
  SCANNING(ScanningAttributeLoader.class, 4),
  SINGLE_ROW(SingleRowAttributeLoader.class, 3),
  ITEM(ItemAttributeLoader.class, 2),
  DERIVED(DerivedAttributeLoader.class, 1);

  private final Class<? extends AttributeLoader> myLoaderClass;
  private final int myLoaderWeight;

  LoaderType(Class<? extends AttributeLoader> loaderClass, int weight) {
    myLoaderClass = loaderClass;
    myLoaderWeight = weight;
  }

  public Class<? extends AttributeLoader> getLoaderClass() {
    return myLoaderClass;
  }

  public int getLoaderWeight() {
    return myLoaderWeight;
  }

  public boolean is(@NotNull AttributeLoader<?> loader) {
    return myLoaderClass.isInstance(loader);
  }

  public static LoaderType getType(@NotNull AttributeLoader<?> loader) {
    return getType(loader.getClass());
  }

  public static LoaderType getType(@NotNull Class<?> loaderClass) {
    for (LoaderType type : values()) {
      if (type.getLoaderClass().isAssignableFrom(loaderClass)) {
        assert getNumberOfTerminalInterfacesImplements(loaderClass) == 1 : loaderClass;
        return type;
      }
    }
    throw new IllegalArgumentException("Unsupported AttributeLoader type: " + loaderClass);
  }

  private static int getNumberOfTerminalInterfacesImplements(@NotNull Class<?> loaderClass) {
    int interfacesNumber = 0;
    for (LoaderType type : values()) {
      if (type.getLoaderClass().isAssignableFrom(loaderClass)) {
        interfacesNumber++;
      }
    }
    return interfacesNumber;
  }
}
