package com.almworks.jira.structure.api.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class TypeUtils {
  @SuppressWarnings("unchecked")
  public static <T> Class<Set<T>> setType() {
    return (Class) Set.class;
  }

  @SuppressWarnings("unchecked")
  public static <T, V> Class<Map<T, V>> mapType() {
    return (Class) Map.class;
  }

  @SuppressWarnings("unchecked")
  public static <T> Class<List<T>> listType() {
    return (Class) List.class;
  }

  public static long nn(@Nullable Long value, long defaultValue) {
    return value == null ? defaultValue : value;
  }

  public static int nn(@Nullable Integer value, int defaultValue) {
    return value == null ? defaultValue : value;
  }

  @NotNull
  public static <T> T nnv(@Nullable T value, @NotNull T defaultValue) {
    return value == null ? defaultValue : value;
  }

  public static long lv(String v, long defaultValue) {
    if (v == null) return defaultValue;
    try {
      return Long.parseLong(v);
    } catch (NumberFormatException e) {
      return defaultValue;
    }
  }

  public static int iv(String v, int defaultValue) {
    if (v == null) return defaultValue;
    try {
      return Integer.parseInt(v);
    } catch (NumberFormatException e) {
      return defaultValue;
    }
  }

  public static Long lvn(String v) {
    if (v == null) return null;
    try {
      return Long.parseLong(v);
    } catch (NumberFormatException e) {
      return null;
    }
  }

  public static Integer ivn(String v) {
    if (v == null) return null;
    try {
      return Integer.parseInt(v);
    } catch (NumberFormatException e) {
      return null;
    }
  }

  public static String nn(String value) {
    return value == null ? "" : value;
  }

  public static long nnl(Long value) {
    return value == null ? 0L : value;
  }

  public static int nni(Integer value) {
    return value == null ? 0 : value;
  }

  public static boolean fitsIntoInt(long value) {
    return value == ((int) value);
  }
}
