package com.almworks.jira.structure.api.template;

import com.almworks.jira.structure.api.structure.Structure;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author alexeypegov
 */
public class EmptyTemplate implements NewStructureTemplate {

  @Override
  public boolean isEnabled() {
    return true;
  }

  @NotNull
  @Override
  public String getInitialStep() {
    return NewStructureTemplateStep.END_STEP;
  }

  @NotNull
  @Override
  public NewStructureTemplateStep createStep(@NotNull String step, @NotNull Map<String, Object> params, NewStructureTemplateContext context) throws StructureTemplateException {
    throw new StructureTemplateException(context.getText("s.tpl.error.unknown-step", context.htmlEncode(step)));
  }

  @Override
  public void configureNewStructure(@NotNull Structure structure, @NotNull Map<String, Object> params) throws StructureTemplateException {
    // does nothing
  }
}
