package com.almworks.jira.structure.api.process;

import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * <p><b>ProcessHandleManager</b> allows to create new processes and access existing ones</p>
 */
public interface ProcessHandleManager {
  /**
   * Creates new process
   * @param managingUser User that will be allowed to manage the process
   * @param displayParameters Display parameters of the process
   * @return ProcessHandle object to read and update process state
   */
  @NotNull
  ProcessHandle createNew(@Nullable ApplicationUser managingUser, @Nullable ProcessDisplayParameters displayParameters);

  /**
   * @param id ID of the process
   * @return ProcessInfo object to read process state. Null if there is no such process
   */
  @Nullable
  ProcessInfo getInfo(@NotNull Long id);

  /**
   * @param id ID of the process
   * @return ProcessFeedback object to update process state. Null if there is no such process
   */
  @Nullable
  ProcessFeedback getFeedback(@NotNull Long id);

  /**
   * @param id ID of the process
   * @return ProcessUIController object to update UI. Null if there is no such process
   */
  @Nullable
  ProcessUIController getUIController(@NotNull Long id);

  /**
   * Deletes the process with the given id
   * @param id ID of the process
   */
  void delete(long id);
}
