package com.almworks.jira.structure.api.event;

import org.jetbrains.annotations.NotNull;

/**
 * <p><code>IssueListener</code> is a simple interface that receives notifications that
 * an issue has changed.</p>
 *
 * <p><strong>Important note:</strong> the called listener must execute as quickly as possible.
 * The locks may be acquired if needed, but it's better to avoid them.</p>
 *
 * @author Igor Sereda
 * @see IssueEventBridge
 */
public interface IssueListener {
  /**
   * Process the event. This method is called whenever issue change notification is received from
   * JIRA, or when other components report issue changes via {@link IssueEventBridge#reportChanges}.
   *
   * @param event the event object
   */
  void onIssueChanged(@NotNull JiraChangeEvent event);
}
