package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeContext;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;

public class InheritedValueLoader<T> extends AbstractPropagateLoader<T> {
  private final AttributeSpec<T> myValueSpec;
  private final boolean myForceParentValue;

  public InheritedValueLoader(AttributeSpec<T> spec, @NotNull AttributeSpec<T> valueSpec, boolean forceParentValue) {
    super(spec);
    myValueSpec = valueSpec;
    myForceParentValue = forceParentValue;
  }

  public Set<AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myValueSpec);
  }

  @Nullable
  @Override
  public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(
    @NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent parentContext)
  {
    boolean allowChildValue = !(myForceParentValue && parentValue.isDefined());
    return (row, context) -> {
      AttributeValue<T> childValue = context.getDependencyAttributeValue(myValueSpec);
      return childValue.isDefined() && allowChildValue ? childValue : parentValue;
    };
  }
}
