/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.rest;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.ValueFormat;
import com.almworks.jira.structure.api.util.ConsiderateLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public final class RestAttributeSpec {
    private static final Logger logger = LoggerFactory.getLogger(AttributeSpec.class);
    private static final ConsiderateLogger considerateLogger = new ConsiderateLogger(logger);
    private static final Map<String, ValueFormat<?>> RECOGNIZED_FORMATS = RestAttributeSpec.createRecognizedFormatsMap();
    @XmlElement
    public String id;
    @XmlElement
    public Map params;
    @XmlElement
    public String format;

    private static Map<String, ValueFormat<?>> createRecognizedFormatsMap() {
        ValueFormat[] formats;
        HashMap<String, ValueFormat> r = new HashMap<String, ValueFormat>();
        for (ValueFormat format : formats = new ValueFormat[]{ValueFormat.HTML, ValueFormat.TEXT, ValueFormat.JSON_OBJECT, ValueFormat.JSON_ARRAY, ValueFormat.NUMBER, ValueFormat.BOOLEAN, ValueFormat.ID, ValueFormat.TIME, ValueFormat.DURATION, ValueFormat.ANY}) {
            r.put(format.getFormatId(), format);
        }
        return Collections.unmodifiableMap(r);
    }

    @Nullable
    public static AttributeSpec<?> fromRest(@Nullable RestAttributeSpec spec) {
        if (spec == null) {
            return null;
        }
        try {
            return RestAttributeSpec.fromRestNotNull(spec);
        }
        catch (IllegalArgumentException e) {
            considerateLogger.warn("spec " + spec, "cannot be deserialized: " + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static AttributeSpec<?> fromRestNotNull(@NotNull RestAttributeSpec spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException();
        }
        ValueFormat<?> format = RECOGNIZED_FORMATS.get(spec.format);
        if (format == null) {
            throw new IllegalArgumentException("format " + spec.format + " is unknown");
        }
        return new AttributeSpec(spec.id, format, spec.params);
    }

    @NotNull
    public static RestAttributeSpec toRest(@NotNull AttributeSpec<?> spec) {
        RestAttributeSpec ras = new RestAttributeSpec();
        ras.id = spec.getId();
        ras.format = spec.getFormat().getFormatId();
        ras.params = spec.getParamsMap();
        if (ras.params.isEmpty()) {
            ras.params = null;
        }
        return ras;
    }

    @NotNull
    public static List<AttributeSpec<?>> fromRestCollection(@Nullable Collection<? extends RestAttributeSpec> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        return source.stream().map(RestAttributeSpec::fromRest).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String toString() {
        return "(" + this.id + "," + this.format + "," + this.params + ")";
    }
}

