/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest;

import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.pull.DataVersion;
import com.atlassian.annotations.PublicApi;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@PublicApi
@Immutable
public final class VersionedForest {
    public static final VersionedForest EMPTY = new VersionedForest(Forest.EMPTY, DataVersion.ZERO);
    @NotNull
    private final Forest myForest;
    @NotNull
    private final DataVersion myVersion;

    public VersionedForest(@NotNull Forest forest, @NotNull DataVersion version) {
        if (forest == null) {
            throw new IllegalArgumentException("forest cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version cannot be null");
        }
        assert (forest.isImmutable()) : forest;
        this.myForest = forest;
        this.myVersion = version;
    }

    @NotNull
    public Forest getForest() {
        return this.myForest;
    }

    @NotNull
    public DataVersion getVersion() {
        return this.myVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedForest that = (VersionedForest)o;
        if (!this.myForest.equals(that.myForest)) {
            return false;
        }
        return this.myVersion.equals(that.myVersion);
    }

    public int hashCode() {
        int result = this.myForest.hashCode();
        result = 31 * result + this.myVersion.hashCode();
        return result;
    }

    public String toString() {
        return "VersionedForest{" + this.myForest + ", " + this.myVersion + '}';
    }
}

