/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.generator.util;

import com.almworks.integers.LongOpenHashSet;
import com.almworks.integers.LongSet;
import com.almworks.integers.WritableLongSet;
import com.almworks.jira.structure.api.generator.ItemChangeFilter;
import com.almworks.jira.structure.api.generator.StructureGenerator;
import com.almworks.jira.structure.api.generator.util.RecordingItemChangeFilter;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicItemChangeFilter
implements RecordingItemChangeFilter {
    private final LongSet myReadonlyIssues;
    @Nullable
    private final WritableLongSet myWritableIssues;
    private final Set<ItemIdentity> myNonIssues;

    private BasicItemChangeFilter(LongSet readonlyIssues, @Nullable WritableLongSet writableIssues, Set<ItemIdentity> nonIssues) {
        assert (writableIssues == null ^ writableIssues == readonlyIssues);
        this.myReadonlyIssues = readonlyIssues;
        this.myWritableIssues = writableIssues;
        this.myNonIssues = nonIssues;
    }

    protected BasicItemChangeFilter(WritableLongSet writableIssues, Set<ItemIdentity> writableNonIssues) {
        this((LongSet)writableIssues, writableIssues, writableNonIssues);
    }

    public static ItemChangeFilter forIssues(@NotNull LongSet issues) {
        return new BasicItemChangeFilter(issues, null, Collections.emptySet());
    }

    public static ItemChangeFilter forItems(@NotNull LongSet issues, Set<ItemIdentity> nonIssues) {
        return new BasicItemChangeFilter(issues, null, nonIssues);
    }

    public static RecordingItemChangeFilter createRecording() {
        return new BasicItemChangeFilter((WritableLongSet)new LongOpenHashSet(), new HashSet<ItemIdentity>());
    }

    public static RecordingItemChangeFilter createRecording(ItemIdentity ... items) {
        RecordingItemChangeFilter recording = BasicItemChangeFilter.createRecording();
        for (ItemIdentity item : items) {
            recording.recordItem(item);
        }
        return recording;
    }

    @Override
    public final void recordItem(StructureRow row) {
        ItemIdentity itemId = row.getItemId();
        this.recordItem(itemId);
    }

    @Override
    public final void recordItem(ItemIdentity itemId) {
        if (this.myWritableIssues != null) {
            if (CoreIdentities.isIssue(itemId)) {
                this.myWritableIssues.add(itemId.getLongId());
            } else {
                this.myNonIssues.add(itemId);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean accept(@NotNull Set<ItemIdentity> itemIds, @NotNull StructureGenerator.ItemChangeFilterContext context) {
        for (ItemIdentity itemId : itemIds) {
            if (!(CoreIdentities.isIssue(itemId) ? this.myReadonlyIssues.contains(itemId.getLongId()) : this.myNonIssues.contains(itemId))) continue;
            return true;
        }
        return false;
    }
}

